package com.biz.crm.member.business.member.sdk.vo;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.biz.crm.member.business.member.sdk.dto.HolidayIntegralDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * 节日Vo
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/20 17:17
 **/
@Getter
@Setter
@ApiModel(value = "HolidayVo", description = "节日Vo")
public class HolidayVo extends TenantFlagOpVo {

    @ApiModelProperty("节日编码")
    private String code;

    @ApiModelProperty("节日名称")
    private String name;

    @ApiModelProperty("节日类型,数据字典:mms_holiday_type 枚举:HolidayTypeEnum")
    private String type;

    @ApiModelProperty("节日日期开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date holidayStartDate;

    @ApiModelProperty("节日日期结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date holidayEndDate;

    @ApiModelProperty("单个用户额外积分上限")
    private Integer extraIntegralTop;


    @ApiModelProperty("积分倍数配置")
    List<HolidayIntegralVo> integrals;


}
