package com.biz.crm.member.business.member.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * @author 吴平
 * @version 1.0.0
 * @data 2023/6/16 11:10
 * @description 资讯分类管理VO
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "InfoCategoryVO", description = "资讯分类VO")
public class InfoCategoryVo extends TenantFlagOpVo {

  @ApiModelProperty("资讯分类编码")
  private String code;

  @ApiModelProperty("资讯分类")
  private String infoName;

  @ApiModelProperty("排序")
  private Integer infoSort;

  @ApiModelProperty("应用范围，数据字典:mms_info_category,枚举:InfoCategoryRangeEnum")
  private String applyRange;
}
