package com.biz.crm.member.business.member.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import javax.persistence.Column;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * @author 吴平
 * @version 1.0.0
 * @data 2023/6/19 10:01
 * @description
 */
@Data
@ApiModel(value = "InfoManageVo", description = "资讯管理Vo")
public class InfoManageVo extends TenantFlagOpVo {
  @ApiModelProperty("资讯编码")
  private String code;

  @ApiModelProperty("序号")
  private Integer  serialNum;

  @ApiModelProperty("标题")
  private String infoTitle;

  @ApiModelProperty("应用模块,数据字典:mms_info_apply_model,枚举:InfoApplyModelEnum")
  private String applyModel;

  @ApiModelProperty("资讯分类===》对应资讯分类中的资讯编码code")
  private String infoCategory;

  @ApiModelProperty("资讯分类名")
  private String infoCategoryName;

  @ApiModelProperty("精选分类========》对应精选分类中的精选编码code")
  private String choiceNessCategory;

  @ApiModelProperty("精选分类名")
  private String choiceNessCategoryName;

  @ApiModelProperty("资讯类型,数据字典:mms_info_manage_type,枚举:InfoTypeEnum")
  private String infoType;

  @ApiModelProperty("开始时间")
  @JsonFormat(
      locale = "zh",
      timezone = "GMT+8",
      pattern = "yyyy-MM-dd HH:mm:ss"
  )
  @DateTimeFormat(
      pattern = "yyyy-MM-dd HH:mm:ss"
  )
  private Date startTime;

  @ApiModelProperty("结束时间")
  @JsonFormat(
      locale = "zh",
      timezone = "GMT+8",
      pattern = "yyyy-MM-dd HH:mm:ss"
  )
  @DateTimeFormat(
      pattern = "yyyy-MM-dd HH:mm:ss"
  )
  private Date endTime;

  @ApiModelProperty("跳转链接")
  private String targetUrl;

  @ApiModelProperty("封面图")
  private String overPic;

  @ApiModelProperty("分享图")
  private String sharePic;

  @ApiModelProperty("图文详情")
  private String infoDetail;

  @ApiModelProperty("阅读量")
  private Integer readNum;

  @ApiModelProperty("点赞量")
  private Integer upvoteNum;

  @ApiModelProperty("评论量")
  private Integer discussNum;

  @ApiModelProperty("当前用户是否已点赞")
  private Boolean alreadyUpvote;

}
