package com.biz.crm.member.business.member.sdk.vo;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import javax.persistence.Column;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author hupan
 * @date 2023/6/13 17:17
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "LabelDetailVo", description = "标签管理Vo")
public class LabelDetailVo extends TenantFlagOpDto {

  @ApiModelProperty("标签表的主键，用于关联标签表")
  private String labelCode;

  @ApiModelProperty("对应的条件类型,数据字典:mms_label_detail,枚举:LabelDetailEnum")
  private String conditionType;

  @ApiModelProperty("条件对应的最小值")
  private Integer min;

  @ApiModelProperty("条件对应的最大值")
  private Integer max;

  @ApiModelProperty("等级名称")
  private String levelName;

  @ApiModelProperty("等级编码")
  private String levelCode;
}
