package com.biz.crm.member.business.member.sdk.vo;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import javax.persistence.Column;
import lombok.Data;
import lombok.EqualsAndHashCode;


@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "LabelVo", description = "标签管理Vo")
public class LabelVo extends TenantFlagOpDto {

  @ApiModelProperty("标签名称")
  private String name;

  @ApiModelProperty("标签编码")
  private String code;

  @ApiModelProperty("标签分类名称=>对应标签分类管理的名称")
  private String categoryName;

  @ApiModelProperty("标签分类编码")
  private String categoryCode;

  @ApiModelProperty("标签类型,标签类型,数据字典mms_label_manage,枚举LabelManageEnum")
  private String type;

  @ApiModelProperty("会员数量，预留字段，暂时没有值")
  private Integer memberNumber;

  @ApiModelProperty("会员数量排名，预留字段，暂时没有值")
  private Integer memberSort;

  @ApiModelProperty("明细")
  List<LabelDetailVo> conditions;
}
