package com.biz.crm.member.business.member.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 等级管理-权益配置明细vo
 *
 * @author zouhs
 * @date 2023-06-13 09:51:06
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "等级管理-权益配置明细Vo")
public class LevelManageBenefitsDetailVo extends TenantFlagOpVo {

  @ApiModelProperty("等级编码")
  private String levelCode;

  @ApiModelProperty("等级关联权益")
  private String levelManageBenefitsCode;

  @ApiModelProperty("权益编码")
  private String code;

  @ApiModelProperty("权益名称")
  private String name;

  @ApiModelProperty("权益类型,数据字典:mms_benefits_type,枚举:BenefitsTypeEnum")
  private String type;

  @ApiModelProperty("说明")
  private String remarkDesc;

  @ApiModelProperty("排序")
  private Integer seq;

  @ApiModelProperty("数量")
  private Integer num;

}

