package com.biz.crm.member.business.member.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.List;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 等级管理vo
 *
 * @author zouhs
 * @date 2023-06-13 09:50:11
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "等级管理Vo")
public class LevelManageVo extends TenantFlagOpVo {

  @ApiModelProperty("等级编码")
  private String levelCode;

  @ApiModelProperty("等级")
  private Integer levelNum;

  @ApiModelProperty("等级名称")
  private String levelName;

  @ApiModelProperty("成长值区间开始")
  private Integer growStart;

  @ApiModelProperty("成长值区间结束")
  private Integer growEnd;

  @ApiModelProperty("第一年该等级卡片")
  private String cardImageOne;

  @ApiModelProperty("连续一年以上等级卡片")
  private String cardImageTwo;

  @ApiModelProperty("权益展示会员卡片")
  private String cardImageThree;

  @ApiModelProperty("16进制背景颜色")
  private String backgroundColor;

  @ApiModelProperty("到期扣除比例")
  private BigDecimal expireDeductRatio;

  @ApiModelProperty("激活成长值")
  private Integer activeGrow;

  @ApiModelProperty("等级权益列表")
  private List<LevelManageBenefitsVo> list;

}

