package com.biz.crm.member.business.member.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 会员信息vo
 *
 * @author zouhs
 * @date 2023-06-19 14:25:08
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "会员信息Vo")
public class MemberInfoAllVo extends TenantFlagOpVo {
  @ApiModelProperty("会员编码")
  private String memberCode;

  @ApiModelProperty("会员昵称")
  private String memberNick;

  @ApiModelProperty("会员手机号")
  private String memberPhone;

  @ApiModelProperty("会员姓名")
  private String memberName;

  @ApiModelProperty("会员头像")
  private String memberAvatar;

  @ApiModelProperty("会员生日")
  private String memberBirthday;

  @ApiModelProperty("注册时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date memberRegister;

  @ApiModelProperty("邀请人数")
  private Integer inviteNum;

  @ApiModelProperty("邀请人编码")
  private String inviteMemberCode;

  @ApiModelProperty("邀请人")
  private String inviteMemberName;

  @ApiModelProperty("邀请时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date inviteMemberRegister;

  @ApiModelProperty("部门")
  private String department;

  @ApiModelProperty("行业编码")
  private String industryCode;

  @ApiModelProperty("行业名称")
  private String industryName;

  @ApiModelProperty("激活状态,数据字典:mms_member_info_active_status,枚举:MemberActiveStatusEnum")
  private String activeStatus;

  @ApiModelProperty("审批人编码")
  private String approvalCode;

  @ApiModelProperty("审批人")
  private String approvalName;

  @ApiModelProperty("审批状态,数据字典:mms_member_info_approval_status,枚举:MemberApprovalStatusEnum")
  private String approvalStatus;

  @ApiModelProperty("审批驳回原因")
  private String approvalRejectDesc;

  @ApiModelProperty("审批时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date approvalDate;

  @ApiModelProperty("关联品鉴顾问编码")
  private String linkTastingCode;

  @ApiModelProperty("关联品鉴顾问")
  private String linkTastingName;

  @ApiModelProperty("关联品鉴顾问手机号")
  private String linkTastingPhone;

  @ApiModelProperty("最后登录时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date lastLoginDate;

  @ApiModelProperty("档案编码")
  private String terminalCode;

  @ApiModelProperty("档案名称")
  private String terminalName;

  @ApiModelProperty("档案类型")
  private String terminalType;

  @ApiModelProperty("联系人")
  private String terminalConnect;

  @ApiModelProperty("手机号")
  private String terminalPhone;

  @ApiModelProperty("开户日期")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date openAccountTime;

  @ApiModelProperty("所属组织编码")
  private String orgCode;

  @ApiModelProperty("所属组织名称")
  private String orgName;

  @ApiModelProperty("省")
  private String provinceCode;

  @ApiModelProperty("省名称")
  private String provinceName;

  @ApiModelProperty("市")
  private String cityCode;

  @ApiModelProperty("市名称")
  private String cityName;

  @ApiModelProperty("区")
  private String districtCode;

  @ApiModelProperty("区名称")
  private String districtName;

  @ApiModelProperty("乡镇/街道")
  private String townshipName;

  @ApiModelProperty("终端地址")
  private String terminalAddress;

  @ApiModelProperty("经度")
  private BigDecimal longitude;

  @ApiModelProperty("纬度")
  private BigDecimal latitude;

  @ApiModelProperty("邮政编码")
  private String zipCode;

  @ApiModelProperty("电子邮箱")
  private String email;

  /**
   * 身份证号码
   */
  @ApiModelProperty("身份证号码")
  private String licensePersonCard;

  /**
   * 营业执照人名称
   */
  @ApiModelProperty("营业执照人名称")
  private String licensePersonName;

  /**
   * 营业执照注册号
   */
  @ApiModelProperty("营业执照注册号")
  private String licenseRegisterNumber;

  /**
   * 营业执照企业名称
   */
  @ApiModelProperty("营业执照企业名称")
  private String licenseFirmName;

  /**
   * 店招照片
   */
  @ApiModelProperty("店招照片")
  private String shopImagePath;

  /**
   * 营业执照照片
   */
  @ApiModelProperty("营业执照照片")
  private String licenseImagePath;

  @ApiModelProperty("关联业务员")
  private List<MemberInfoContactVo> memberInfoContactVoList;

  @ApiModelProperty("关联采供关系")
  private List<MemberInfoSupplyVo> memberInfoSupplyVoList;
}

