package com.biz.crm.member.business.member.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 会员档案vo
 *
 * @author zouhs
 * @date 2023-06-19 14:28:25
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "会员档案Vo")
public class MemberInfoArchivesVo extends TenantFlagOpVo {

  @ApiModelProperty("会员编码")
  private String memberCode;

  @ApiModelProperty("档案编码")
  private String terminalCode;

  @ApiModelProperty("档案名称")
  private String terminalName;

  @ApiModelProperty("档案类型")
  private String terminalType;

  @ApiModelProperty("联系人")
  private String terminalConnect;

  @ApiModelProperty("手机号")
  private String terminalPhone;

  @ApiModelProperty("开户日期")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date openAccountTime;

  @ApiModelProperty("所属组织编码")
  private String orgCode;

  @ApiModelProperty("所属组织名称")
  private String orgName;

  @ApiModelProperty("省")
  private String provinceCode;

  @ApiModelProperty("省名称")
  private String provinceName;

  @ApiModelProperty("市")
  private String cityCode;

  @ApiModelProperty("市名称")
  private String cityName;

  @ApiModelProperty("区")
  private String districtCode;

  @ApiModelProperty("区名称")
  private String districtName;

  @ApiModelProperty("乡镇/街道")
  private String townshipName;

  @ApiModelProperty("终端地址")
  private String terminalAddress;

  @ApiModelProperty("经度")
  private BigDecimal longitude;

  @ApiModelProperty("纬度")
  private BigDecimal latitude;

  @ApiModelProperty("邮政编码")
  private String zipCode;

  @ApiModelProperty("电子邮箱")
  private String email;

  /**
   * 身份证号码
   */
  @ApiModelProperty("身份证号码")
  private String licensePersonCard;

  /**
   * 营业执照人名称
   */
  @ApiModelProperty("营业执照人名称")
  private String licensePersonName;

  /**
   * 营业执照注册号
   */
  @ApiModelProperty("营业执照注册号")
  private String licenseRegisterNumber;

  /**
   * 营业执照企业名称
   */
  @ApiModelProperty("营业执照企业名称")
  private String licenseFirmName;

  /**
   * 店招照片
   */
  @ApiModelProperty("店招照片")
  private String shopImagePath;

  /**
   * 营业执照照片
   */
  @ApiModelProperty("营业执照照片")
  private String licenseImagePath;
}

