package com.biz.crm.member.business.member.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 会员资产vo
 *
 * @author zouhs
 * @date 2023-06-19 14:28:52
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "会员资产Vo")
public class MemberInfoAssetsVo extends TenantFlagOpVo {
  @ApiModelProperty("会员编码")
  private String memberCode;

  @ApiModelProperty("累计积分")
  private Integer totalIntegral;

  @ApiModelProperty("当前积分")
  private Integer currentIntegral;

  @ApiModelProperty("累计成长值")
  private Integer totalGrow;

  @ApiModelProperty("当前成长值")
  private Integer currentGrow;

  @ApiModelProperty("等级编码")
  private String levelCode;

  @ApiModelProperty("等级名称")
  private String levelName;

  @ApiModelProperty("会员权益数")
  private Integer benefitsNum;

  @ApiModelProperty("待兑权益数")
  private Integer stayBenefitsNum;

  @ApiModelProperty("品鉴顾问权益")
  private Integer tastingBenefitsNum;

  @ApiModelProperty("品鉴顾问待兑权益")
  private Integer stayTastingBenefitsNum;

  @ApiModelProperty("大转盘奖品")
  private Integer bigWheelPrizes;

  @ApiModelProperty("待兑大转盘奖品")
  private Integer stayBigWheelPrizes;

  @ApiModelProperty("等级记录")
  private List<MemberInfoLevelChangeRecordVo> list;
}

