package com.biz.crm.member.business.member.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import javax.persistence.Column;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 会员权益关联表vo
 *
 * @author zouhs
 * @date 2023-06-20 15:08:20
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "会员权益关联表Vo")
public class MemberInfoBenefitsVo extends TenantFlagOpVo {
  @ApiModelProperty("会员编码")
  private String memberCode;

  @ApiModelProperty("会员姓名")
  private String memberName;

  @ApiModelProperty("会员手机号")
  private String memberPhone;

  @ApiModelProperty("权益编码")
  private String benefitsCode;

  @ApiModelProperty("权益名称")
  private String benefitsName;

  @ApiModelProperty("权益类型,数据字典:mms_benefits_type,枚举:BenefitsTypeEnum")
  private String benefitsType;

  @ApiModelProperty("兑换状态,数据字典:mms_member_info_benefits_exchange_status,枚举:MemberInfoBenefitsStatusEnum")
  private String exchangeStatus;

  @ApiModelProperty("会员权益类型,数据字典:mms_member_info_benefits_member_benefits_type,枚举:MemberInfoMemberBenefitsTypeEnum")
  private String memberBenefitsType;

  @ApiModelProperty("转赠人编码")
  private String giftCode;

  @ApiModelProperty("转赠人姓名")
  private String giftName;

  @ApiModelProperty("转赠人手机号")
  private String giftPhone;

  @ApiModelProperty("兑换时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date exchangeTime;

  @ApiModelProperty("领取过期时间")
  @JsonFormat(
      locale = "zh",
      timezone = "GMT+8",
      pattern = "yyyy-MM-dd HH:mm:ss"
  )
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date exchangeExpireTime;

  @ApiModelProperty("关联订单号")
  private String orderCode;

  @ApiModelProperty("单位,数据字典:mms_benefits_unit,枚举:BenefitsUnitEnum")
  private String unit;

  @ApiModelProperty("产品图片")
  private String productImage;

  @ApiModelProperty("产品详情")
  private String productDesc;

  @ApiModelProperty("兑换有效期(月)")
  private Integer exchangeValidPeriod;

  @ApiModelProperty("使用有效期(天)")
  private Integer useValidPeriod;

  @ApiModelProperty("数量")
  private Integer num;

  @ApiModelProperty("等级关联权益")
  private String levelManageBenefitsCode;

  @ApiModelProperty("关联组织编码")
  private String orgCode;

  @ApiModelProperty("关联组织名称")
  private String orgName;
}

