package com.biz.crm.member.business.member.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 会员退货记录vo
 *
 * @author zouhs
 * @date 2023-06-28 16:54:32
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "会员退货记录Vo")
public class MemberInfoComeBackRecordVo extends TenantFlagOpVo {

  @ApiModelProperty("会员编码")
  private String memberCode;

  @ApiModelProperty("单据流水号")
  private String comeBackCode;

  @ApiModelProperty("退货单位编码")
  private String customerCode;

  @ApiModelProperty("退货单位")
  private String customerName;

  @ApiModelProperty("收货单位编码")
  private String terminalCode;

  @ApiModelProperty("收货单位")
  private String terminalName;

  @ApiModelProperty("组织编码")
  private String orgCode;

  @ApiModelProperty("组织名称")
  private String orgName;

  @ApiModelProperty("单据时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date documentTime;

  @ApiModelProperty("退货时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date backTime;

  @ApiModelProperty("扣除成长值")
  private Integer deductionGrow;

}

