package com.biz.crm.member.business.member.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 业务员联系人vo
 *
 * @author zouhs
 * @date 2023-06-19 14:29:18
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "业务员联系人Vo")
public class MemberInfoContactVo extends TenantFlagOpVo {

  @ApiModelProperty("会员编码")
  private String memberCode;

  /** 终端编码 */
  @ApiModelProperty("终端编码")
  private String terminalCode;

  /** 联系人姓名 */
  @ApiModelProperty("联系人姓名")
  private String contactName;

  /** 联系人电话 */
  @ApiModelProperty("联系人电话")
  private String contactPhone;

  /** 主联系人,1是0否 */
  @ApiModelProperty("主联系人,true是false否")
  private Boolean contactMain;

  /** 角色名称 */
  @ApiModelProperty("角色名称")
  private String roleName;

  /** 角色编码 */
  @ApiModelProperty("角色编码")
  private String roleCode;

}

