package com.biz.crm.member.business.member.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 会员成长值变动记录vo
 *
 * @author zouhs
 * @date 2023-06-19 14:29:43
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "会员成长值变动记录Vo")
public class MemberInfoGrowRecordVo extends TenantFlagOpVo {

  @ApiModelProperty("会员ID")
  private String memberId;

  @ApiModelProperty("会员编码")
  private String memberCode;

  @ApiModelProperty("发放流水号")
  private String growCode;

  @ApiModelProperty("会员名称")
  private String memberName;

  @ApiModelProperty("会员手机号")
  private String memberPhone;

  @ApiModelProperty("发放时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date optTime;

  @ApiModelProperty("操作前数值")
  private Integer beforeGrow;

  @ApiModelProperty("成长值")
  private Integer grow;

  @ApiModelProperty("操作后数值")
  private Integer afterGrow;

  @ApiModelProperty("来源")
  private String source;

}

