package com.biz.crm.member.business.member.sdk.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import javax.persistence.Column;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * @author hupan
 * @date 2023/6/27 10:48
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "小程序会员积分变动记录Vo")
public class MemberInfoIntegralRecordAPIVo {

  @ApiModelProperty("当前积分")
  private Integer currentIntegral;

  @ApiModelProperty("近30天将过期的积分")
  private Integer expiringSoon;

  @ApiModelProperty("发放时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date optTime;

  @ApiModelProperty("积分")
  private Integer integral;

  @ApiModelProperty("发放流水号,对应签收/退货表里面的单据流水号")
  private String resourceDocumentCode;

  @ApiModelProperty("增加/减少,枚举,数据字典:mms_grow_operation,枚举类:GrowOperationEnum")
  private String operationFlag;

  @ApiModelProperty("来源,枚举,数据字典mms_member_integral_source,枚举类:IntegralSourceEnum")
  private String source;
}
