package com.biz.crm.member.business.member.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 会员积分变动记录vo
 *
 * @author zouhs
 * @date 2023-06-19 14:38:19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "会员积分变动记录Vo")
public class MemberInfoIntegralRecordVo extends TenantFlagOpVo {

  @ApiModelProperty("会员ID")
  private String memberId;

  @ApiModelProperty("会员编码")
  private String memberCode;

  @ApiModelProperty("会员名称")
  private String memberName;

  @ApiModelProperty("会员手机号")
  private String memberPhone;

  @ApiModelProperty("发放流水号")
  private String integralCode;

  @ApiModelProperty("发放时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date optTime;

  @ApiModelProperty("操作前数值")
  private Integer beforeIntegral;

  @ApiModelProperty("积分")
  private Integer integral;

  @ApiModelProperty("操作后数值")
  private Integer afterIntegral;

  @ApiModelProperty("来源,数据字典:mms_member_integral_source,枚举:IntegralSourceEnum")
  private String source;

  @ApiModelProperty("来源类型,数据字典:mms_member_integral_source_type,枚举:IntegralSourceEnum")
  private String type;

}

