package com.biz.crm.member.business.member.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.List;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 会员签收记录vo
 *
 * @author zouhs
 * @date 2023-06-28 16:53:43
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "会员签收记录Vo")
public class MemberInfoReceiptRecordVo extends TenantFlagOpVo {

  @ApiModelProperty("会员编码")
  private String memberCode;

  @ApiModelProperty("单据流水号")
  private String receiptCode;

  @ApiModelProperty("发货单位编码")
  private String customerCode;

  @ApiModelProperty("发货单位")
  private String customerName;

  @ApiModelProperty("收货单位编码")
  private String terminalCode;

  @ApiModelProperty("收货单位")
  private String terminalName;

  @ApiModelProperty("组织编码")
  private String orgCode;

  @ApiModelProperty("组织名称")
  private String orgName;

  @ApiModelProperty("单据时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date documentTime;

  @ApiModelProperty("签收时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date receiptTime;

  @ApiModelProperty("签收地点")
  private String receiptAddr;

  @ApiModelProperty("获得成长值")
  private Integer getGrow;

  @ApiModelProperty("产品明细")
  private List<MemberInfoReceiptRecordDetailVo> list;

}

