package com.biz.crm.member.business.member.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 会员签到表vo
 *
 * @author zouhs
 * @date 2023-06-27 13:44:25
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "会员签到表Vo")
public class MemberInfoSignVo extends TenantFlagOpVo {

  @ApiModelProperty("会员编码")
  private String memberCode;

  @ApiModelProperty("会员昵称")
  private String memberNick;

  @ApiModelProperty("会员手机号")
  private String memberPhone;

  @ApiModelProperty("会员姓名")
  private String memberName;

  @ApiModelProperty("签到编码")
  private String signCode;

  @ApiModelProperty("签到时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date signTime;

  @ApiModelProperty("真实积分")
  private Integer integral;

}

