package com.biz.crm.member.business.member.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import javax.persistence.Column;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 会员信息vo
 *
 * @author zouhs
 * @date 2023-06-19 14:25:08
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "会员信息Vo")
public class MemberInfoVo extends TenantFlagOpVo {
  @ApiModelProperty("会员编码")
  private String memberCode;

  @ApiModelProperty("会员昵称")
  private String memberNick;

  @ApiModelProperty("会员手机号")
  private String memberPhone;

  @ApiModelProperty("会员姓名")
  private String memberName;

  @ApiModelProperty("会员头像")
  private String memberAvatar;

  @ApiModelProperty("会员生日")
  private String memberBirthday;

  @ApiModelProperty("用户类型 1 会员 2 游客")
  private String userType;

  @ApiModelProperty("注册时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date memberRegister;

  @ApiModelProperty("邀请人数")
  private Integer inviteNum;

  @ApiModelProperty("邀请人编码")
  private String inviteMemberCode;

  @ApiModelProperty("邀请人")
  private String inviteMemberName;

  @ApiModelProperty("邀请时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date inviteMemberRegister;

  @ApiModelProperty("部门")
  private String department;

  @ApiModelProperty("行业编码")
  private String industryCode;

  @ApiModelProperty("行业名称")
  private String industryName;

  @ApiModelProperty("激活状态,数据字典:mms_member_info_active_status,枚举:MemberActiveStatusEnum")
  private String activeStatus;

  @ApiModelProperty("审批人编码")
  private String approvalCode;

  @ApiModelProperty("审批人")
  private String approvalName;

  @ApiModelProperty("审批状态,数据字典:mms_member_info_approval_status,枚举:MemberApprovalStatusEnum")
  private String approvalStatus;

  @ApiModelProperty("审批驳回原因")
  private String approvalRejectDesc;

  @ApiModelProperty("审批时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date approvalDate;

  @ApiModelProperty("关联品鉴顾问编码")
  private String linkTastingCode;

  @ApiModelProperty("关联品鉴顾问")
  private String linkTastingName;

  @ApiModelProperty("关联品鉴顾问手机号")
  private String linkTastingPhone;

  @ApiModelProperty("最后登录时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date lastLoginDate;
}

