package com.biz.crm.member.business.member.sdk.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import javax.persistence.Column;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * @author hupan
 * @date 2023/6/29 16:25
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "会员邀请记录Vo")
public class MemberInviteRecordVo extends TenantFlagOpVo {

  @ApiModelProperty("邀请人姓名")
  private String inviterName;

  @ApiModelProperty("邀请人手机号")
  private String inviterPhone;

  @ApiModelProperty("邀请时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date inviteTime;

  @ApiModelProperty("受邀人姓名")
  private String inviteeName;

  @ApiModelProperty("受邀人手机号")
  private String inviteePhone;
}
