package com.biz.crm.member.business.member.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * 消息弹窗管理vo
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/15 13:54
 **/
@Getter
@Setter
@ApiModel(value = "MessageManageVo", description = "消息弹窗管理vo")
public class MessageManageVo extends TenantFlagOpVo {

    @ApiModelProperty("消息管理编码")
    private String code;

    @ApiModelProperty("触发类型,数据字典:mms_trigger_type,枚举:TriggerTypeEnum")
    private String triggerType;

    @ApiModelProperty("触发类型名称")
    private String triggerTypeName;

    @ApiModelProperty("触发条件,数据字典:mms_trigger_condition,枚举:TriggerConditionEnum")
    private String triggerCondition;

    @ApiModelProperty("触发条件名称")
    private String triggerConditionName;

    @ApiModelProperty("节日编码")
    private String holidayCode;

    @ApiModelProperty("节日名称")
    private String holidayName;

    @ApiModelProperty("权重")
    private String triggerWeight;

    @ApiModelProperty("是否消息通知")
    private Boolean messageNotify;

    @ApiModelProperty("是否开屏弹窗通知")
    private Boolean popupNotify;

    @ApiModelProperty("消息")
    private MessageNotifyVo message;

    @ApiModelProperty("弹窗")
    private PopupNotifyVo popup;
}
