
package com.biz.crm.member.business.member.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import java.math.BigDecimal;

/**
 * 奖品VO
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/19 13:55
 **/
@Getter
@Setter
@ApiModel(value = "PrizeVo", description = "奖品VO")
public class PrizeVo extends TenantFlagOpVo {

    @ApiModelProperty("奖品编码")
    private String code;

    @ApiModelProperty("奖品名称")
    private String prizeName;


    @ApiModelProperty("奖品类型编码,数据字典:mms_prize_type,枚举:PrizeTypeEnum")
    private String prizeType;


    @ApiModelProperty("奖品类型名称")
    private String prizeTypeName;

    @ApiModelProperty("单价")
    private BigDecimal unitPrice;

    @ApiModelProperty("单位编码,数据字典:mms_prize_unit,枚举:PrizeUnitEnum")
    private String  unitCode;

    @ApiModelProperty("单位名称")
    private String unitName;

    @ApiModelProperty("是否有库存")
    private String inventory;

    @ApiModelProperty("库存数量")
    private BigDecimal inventoryNum;

    @ApiModelProperty("领取有效期")
    private Integer receiveTimeLimit;

    @ApiModelProperty("虚拟有效期")
    private Integer virtualTimeLimit;

    @ApiModelProperty("文件id")
    private String fileId;

    @ApiModelProperty("文件名")
    private String fileName;

    @ApiModelProperty("商品详情")
    private String productDes;

    @ApiModelProperty("总数量")
    private BigDecimal totalNum = BigDecimal.ZERO;

    @ApiModelProperty("投放已中奖")
    private BigDecimal putNumHit = BigDecimal.ZERO;

    @ApiModelProperty("中奖已过期")
    private BigDecimal expired = BigDecimal.ZERO;

    @ApiModelProperty("领取已过期")
    private BigDecimal expiredClaimed = BigDecimal.ZERO;

    //---

    @ApiModelProperty("可投放数量")
    private BigDecimal canPutNum;

    @ApiModelProperty("投放数量")
    private BigDecimal putNum = BigDecimal.ZERO;

    @ApiModelProperty("中奖已领取")
    private BigDecimal claimed = BigDecimal.ZERO;

    @ApiModelProperty("中奖未领取")
    private BigDecimal waitClaimed = BigDecimal.ZERO;

    @ApiModelProperty("领取已使用")
    private BigDecimal useClaimed = BigDecimal.ZERO;

    @ApiModelProperty("领取未使用")
    private BigDecimal unUseClaimed = BigDecimal.ZERO;



}
