package com.biz.crm.member.business.member.sdk.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import lombok.Data;

/**
 * @author sunx
 * @date 2022/10/11
 */
@Data
@MappedSuperclass
public class ProWorkflowFlagOpEntity extends TenantFlagOpEntity {
  private static final long serialVersionUID = 7419364591192585953L;
  /** 审批流程编码 */
  @ApiModelProperty("审批流程编码")
  @TableField(value = "process_key")
  @Column(name = "process_Key", columnDefinition = "VARCHAR(64) COMMENT '审批流程编码'")
  private String processKey;

  /** 审批状态 */
  @ApiModelProperty("审批状态")
  @TableField(value = "process_status")
  @Column(name = "process_status", columnDefinition = "varchar(10) COMMENT '审批状态'")
  private String processStatus;

  /** 审批单号 */
  @ApiModelProperty("审批单号")
  @TableField(value = "process_number")
  @Column(name = "process_number", columnDefinition = "varchar(64) COMMENT '审批单号'")
  private String processNumber;

  /** 审批备注 */
  @ApiModelProperty("审批备注")
  @TableField(value = "process_remark")
  @Column(name = "process_remark", columnDefinition = "varchar(200) COMMENT '审批备注'")
  private String processRemark;
}
