package com.biz.crm.member.business.member.sdk.vo;

import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * mms_product_exchange_rule 商品兑换规则vo
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/13 15:48
 **/
@Data
@ApiModel(value = "ProductExchangeRuleVo", description = "商品兑换规则vo")
public class ProductExchangeRuleVo extends TenantFlagOpEntity {

    @ApiModelProperty("上架编码")
    private String shelfCode;

    @ApiModelProperty("等级限制编码")
    private String levelCode;

    @ApiModelProperty("等级限制名称")
    private String levelName;

    @ApiModelProperty("兑换周期 数据字典:mms_exchange_period,枚举:ExchangePeriodEnum")
    private String exchangePeriod;

    @ApiModelProperty("兑换周期名称")
    private String exchangePeriodName;

    @ApiModelProperty("可兑数量")
    private BigDecimal quantity;

    @ApiModelProperty("积分价格")
    private BigDecimal integralPrice;


    @ApiModelProperty("库存数量")
    private BigDecimal inventoryQuantity;

    @ApiModelProperty("投放数量")
    private BigDecimal putInNum;

    @ApiModelProperty("上架时间）")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date upDate;

    @ApiModelProperty("下架时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date downDate;

    @ApiModelProperty("使用有效期")
    private Integer validateUse;
}
