package com.biz.crm.member.business.member.sdk.vo;

import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 积分商城 商品信息
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/13 15:23
 **/
@Data
@ApiModel(value = "ProductPageVo",description = "商品分页查询结果vo")
public class ProductPageVo extends TenantFlagOpEntity {

    @ApiModelProperty("上架编码")
    private String code;

    @ApiModelProperty("上架名称")
    private String name;

    @ApiModelProperty("来源")
    private String source;

    @ApiModelProperty("上下架状态")
    private String status;

    @ApiModelProperty("商品编码")
    private String productCode;

    @ApiModelProperty("商品名称")
    private String productName;

    @ApiModelProperty("商品类型(实物，虚拟)")
    private String productType;

    @ApiModelProperty("计量单位")
    private String unitCode;

    @ApiModelProperty("计量单位名称")
    private String unitName;

    @ApiModelProperty("商品分类编码")
    private String productCategoryCode;

    @ApiModelProperty("商品分类名称")
    private String productCategoryName;

    @ApiModelProperty("等级限制编码")
    private String levelCode;

    @ApiModelProperty("等级限制名称")
    private String levelName;

    @ApiModelProperty("兑换周期 数据字典:mms_exchange_period,枚举:ExchangePeriodEnum")
    private String exchangePeriod;

    @ApiModelProperty("兑换周期名称")
    private String exchangePeriodName;

    @ApiModelProperty("可兑数量")
    private BigDecimal quantity;

    @ApiModelProperty("库存数量")
    private BigDecimal inventoryQuantity;

    @ApiModelProperty("积分价格")
    private BigDecimal integralPrice;

    @ApiModelProperty("上架时间）")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date upDate;

    @ApiModelProperty("下架时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date downDate;

    @ApiModelProperty("使用有效期 数据字典:mms_validate_use")
    private Integer validateUse;

    @ApiModelProperty("投放数量")
    private BigDecimal putInNum;

    @ApiModelProperty("已兑数量")
    private BigDecimal exchangedNum;

    @ApiModelProperty("已兑未使用")
    private BigDecimal unUse;

    @ApiModelProperty("已兑已使用")
    private BigDecimal used;

    @ApiModelProperty("已兑已过期")
    private BigDecimal expired;

    @ApiModelProperty("兑换等级说明（小程序积分商城商品列表）")
    private String levelSpecify;

    @ApiModelProperty("已兑换数量（小程序积分商城商品列表）")
    private Integer hasExchange;

    @ApiModelProperty("兑换情况说明（小程序积分商城商品列表）")
    private String exchangeSpecify;

    @ApiModelProperty("缩略图片文件（小程序积分商城商品列表）")
    ProductFileVo smallFile;
}
