package com.biz.crm.member.business.member.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.biz.crm.member.business.member.sdk.dto.ProductFileDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * 积分商城 商品信息 商品vo
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/13 15:23
 **/
@Data
@ApiModel(value = "ProductVo",description = "商品vo")
public class ProductVo extends TenantFlagOpVo {

    @ApiModelProperty("上架编码")
    private String code;

    @ApiModelProperty("上架名称")
    private String name;

    @ApiModelProperty("来源 数据字典:mms_product_source,枚举:ProductSourceEnum")
    private String source;

    @ApiModelProperty("上下架状态 数据字典:mms_shelf_status,枚举:ShelfStatusEnum")
    private String status;

    @ApiModelProperty("商品编码")
    private String productCode;

    @ApiModelProperty("商品名称")
    private String productName;

    @ApiModelProperty("商品类型 数据字典:mms_product_type,枚举:ProductTypeEnum")
    private String productType;

    @ApiModelProperty("计量单位")
    private String unitCode;

    @ApiModelProperty("计量单位名称")
    private String unitName;

    @ApiModelProperty("商品分类编码")
    private String productCategoryCode;

    @ApiModelProperty("商品分类名称")
    private String productCategoryName;

    @ApiModelProperty("商品详情")
    private String productDesc;

    @ApiModelProperty("商品兑换规则vo")
    private ProductExchangeRuleVo rule;

    @ApiModelProperty("商品文件")
    List<ProductFileVo> files;

    @ApiModelProperty("轮播图文件")
    List<ProductFileVo> viewPagerFile;

    @ApiModelProperty("缩略图片文件")
    List<ProductFileVo> smallFile;

    @ApiModelProperty("商品详情图片文件")
    List<ProductFileVo> productFile;

    @ApiModelProperty("兑换等级说明（小程序积分商城商品详情）")
    private String levelSpecify;

    @ApiModelProperty("虚拟货物使用期限（小程序积分商城商品详情）")
    private String validateUse;

    @ApiModelProperty("剩余库存（小程序积分商城商品详情）")
    private BigDecimal inventoryQuantity;

    @ApiModelProperty("兑换情况说明（小程序积分商城商品详情）")
    private String exchangeSpecify;
}
