package com.biz.crm.member.business.member.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author 吴平
 * @version 1.0.0
 * @data 2023/6/21 16:15
 * @description 问题答卷Vo
 */
@ApiModel(value = "QuestionAnswerVo",description = "问题答卷Vo")
@Data
public class QuestionAnswerVo extends TenantFlagOpVo {
  @ApiModelProperty("题目编码")
  private String code;

  @ApiModelProperty("组件字段")
  private String field;

  @ApiModelProperty("提示语")
  private String placeholder;

  @ApiModelProperty("组件类型")
  private String type;

  @ApiModelProperty("是否必填")
  private Boolean required;

  @ApiModelProperty("默认值")
  private String defaultValue;

  @ApiModelProperty("排序(按数字顺序排序)")
  private Integer sortIndex;

  @ApiModelProperty("题目标题")
  private String title;

  @ApiModelProperty("多选/单选的json值")
  private String configJsonValue;

  @ApiModelProperty("用户答题")
  private AnswerRecordVo answerRecordVo;
}
