package com.biz.crm.member.business.member.sdk.vo;

import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.Column;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * @author 吴平
 * @version 1.0.0
 * @data 2023/6/20 14:37
 * @description 问卷Vo
 */
@Data
@ApiModel(value = "QuestionnaireVo", description = "问卷Vo")
public class QuestionnaireVo extends TenantFlagOpVo {

  @ApiModelProperty("问卷编码")
  private String code;

  @ApiModelProperty("问卷标题")
  private String title;

  @ApiModelProperty("参与问卷可获得积分")
  private BigDecimal obtainPoints;

  @ApiModelProperty("开始时间")
  @JsonFormat(
      locale = "zh",
      timezone = "GMT+8",
      pattern = "yyyy-MM-dd HH:mm:ss"
  )
  @DateTimeFormat(
      pattern = "yyyy-MM-dd HH:mm:ss"
  )
  private Date startTime;

  @ApiModelProperty("结束时间")
  @JsonFormat(
      locale = "zh",
      timezone = "GMT+8",
      pattern = "yyyy-MM-dd HH:mm:ss"
  )
  @DateTimeFormat(
      pattern = "yyyy-MM-dd HH:mm:ss"
  )
  private Date endTime;

  @ApiModelProperty("状态,数据字典:mms_questionnaire_status,枚举:QuestionnaireStatusEnum")
  private String pubStatus;

  @ApiModelProperty("提交人数")
  private Integer commitCount;

  @ApiModelProperty("问卷生命周期状态，数据字典:mms_questionnaire_life_cycle_status,枚举:QuestionnaireLifeCycleStatusEnum")
  private String lifeCycleStatus;

  @ApiModelProperty("问卷说明")
  private String description;

  @ApiModelProperty("完成问卷提示")
  private String completeTips;
}
