package com.biz.crm.member.business.member.sdk.vo;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.biz.crm.member.business.member.sdk.dto.RaffleMemberDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import java.util.List;

/**
 * 大转盘活动基础配置Vo
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/19 13:36
 **/
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "RaffleBaseConfigVo", description = "大转盘活动基础配置Vo")
public class RaffleBaseConfigVo extends TenantFlagOpVo {


    @ApiModelProperty("大转盘活动编码")
    private String raffleCode;

    @ApiModelProperty("会员等级编码")
    private String memberLevelCode;

    @ApiModelProperty("会员等级名称")
    private String memberLevelName;

    @ApiModelProperty("一段每天抽奖次数")
    private Integer oneRaffleNum;

    @ApiModelProperty("一段每次消耗积分")
    private Integer oneRaffleUseIntegral;

    @ApiModelProperty("一段每天抽奖次数")
    private Integer twoRaffleNum;

    @ApiModelProperty("一段每次消耗积分")
    private Integer twoRaffleUseIntegral;

    @ApiModelProperty("会员等级集合")
    List<RaffleMemberDto> memberLevels;

    @ApiModelProperty("会员等级json")
    private String memberLevelJson;

}
