package com.biz.crm.member.business.member.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 大转盘管理Vo
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/19 10:42
 **/
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "RaffleManagePageVo", description = "大转盘管理Vo")
public class RaffleManagePageVo extends TenantFlagOpVo {

    @ApiModelProperty("编码")
    private String code;

    @ApiModelProperty("活动名称")
    private String activityName;

    @ApiModelProperty("背景图片id")
    private String backgroundFileId;

    @ApiModelProperty("背景图片名称")
    private String backgroundFileName;

    @ApiModelProperty("转盘图片id")
    private String fileId;

    @ApiModelProperty("转盘图片名称")
    private String fileName;

    @ApiModelProperty("开始按钮图片id")
    private String startButtonFileId;

    @ApiModelProperty("开始按钮图片名称")
    private String startButtonFileName;

    @ApiModelProperty("分割线图片id")
    private String cuttingLineFileId;

    @ApiModelProperty("分割线图片名称")
    private String cuttingLineFileName;

    @ApiModelProperty("活动开始时间（开始）")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startDate;

    @ApiModelProperty("活动结束时间（结束）")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endDate;

    @ApiModelProperty("规则文案")
    private String ruleDes;

    @ApiModelProperty("活动状态, 数据字典:mms_raffle_activity_status 枚举:RaffleActivityStatusEnum")
    private String activityStatus;





}
