
package com.biz.crm.member.business.member.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;

/**
 * 大转盘奖品信息详情Vo
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/19 15:21
 **/
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "RafflePrizeDetailsVo", description = "大转盘奖品信息详情Vo")
public class RafflePrizeDetailsVo extends TenantFlagOpVo {

    @ApiModelProperty("大转盘奖项编码")
    private String code;

    @ApiModelProperty("大转盘编码")
    private String raffleCode;

    @ApiModelProperty("奖品配置编码")
    private String rafflePrizeCode;

    @ApiModelProperty("奖品等级编码")
    private String prizeLevel;

    @ApiModelProperty("奖品等级名称")
    private String prizeLevelName;

    @ApiModelProperty("奖品编码")
    private String prizeCode;

    @ApiModelProperty("奖品名称")
    private String prizeName;

    @ApiModelProperty("奖品类型编码,数据字典:mms_prize_type,枚举:PrizeTypeEnum")
    private String prizeType;

    @ApiModelProperty("奖品类型编码,数据字典:mms_prize_type,枚举:PrizeTypeEnum")
    private String prizeTypeName;

    @ApiModelProperty("文件id")
    private String fileId;

    @ApiModelProperty("单位")
    private String unitCode;

    @ApiModelProperty("单位名称")
    private String unitName;

    @ApiModelProperty("单价")
    private BigDecimal unitPrice;

    @ApiModelProperty("是否有库存")
    private String inventory;

    @ApiModelProperty("库存数量")
    private BigDecimal inventoryNum;

    @ApiModelProperty("展示名称")
    private String showName;

    @ApiModelProperty("数量")
    private BigDecimal quantity;

    @ApiModelProperty("总价格")
    private BigDecimal totalPrice;

    @ApiModelProperty("投放总价值")
    private BigDecimal totalValue;

    @ApiModelProperty("投放份数")
    private BigDecimal putCopies;

    @ApiModelProperty("投放库存份数")
    private BigDecimal putInventoryCopies;

    @ApiModelProperty("投放库存数量")
    private BigDecimal putInventoryNum;

    @ApiModelProperty("概率")
    private BigDecimal prizeProb;

    @ApiModelProperty("可投放数量")
    private BigDecimal canPutNum;

    @ApiModelProperty("投放数量")
    private BigDecimal putNum;

    @ApiModelProperty("使用有效期(天)")
    private Integer useValidate;

    @ApiModelProperty("领取有效期(天)")
    private Integer claimValidate;

    @ApiModelProperty("是否为选择的无库存奖励(奖品发完后选择为无库存奖品)")
    private Boolean prizeFlag;

    @ApiModelProperty("中奖数量")
    private BigDecimal putNumHit = BigDecimal.ZERO;

    @ApiModelProperty("中奖已领取")
    private BigDecimal claimed = BigDecimal.ZERO;

    @ApiModelProperty("中奖未领取")
    private BigDecimal waitClaimed = BigDecimal.ZERO;

    @ApiModelProperty("中奖已过期")
    private BigDecimal expired = BigDecimal.ZERO;

    @ApiModelProperty("领取已使用")
    private BigDecimal useClaimed = BigDecimal.ZERO;

    @ApiModelProperty("领取未使用")
    private BigDecimal unUseClaimed = BigDecimal.ZERO;

    @ApiModelProperty("领取已过期")
    private BigDecimal expiredClaimed = BigDecimal.ZERO;


    //---
    @ApiModelProperty("中奖记录编码")
    private String recordCode;


}
