
package com.biz.crm.member.business.member.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 大转盘中奖记录
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/20 13:39
 **/


@Data
@ApiModel(value = "RafflePrizeRecordVo", description = "大转盘中奖记录Vo")
public class RafflePrizeRecordVo extends TenantFlagOpVo {

    @ApiModelProperty("中奖记录编码")
    private String code;

    @ApiModelProperty("中奖人编码")
    private String memberCode;

    @ApiModelProperty("奖项编码")
    private String rafflePrizeDetailCode;

    @ApiModelProperty("奖品配置编码")
    private String rafflePrizeCode;

    @ApiModelProperty("大转盘活动编码")
    private String activityCode;

    @ApiModelProperty("活动名称")
    private String activityName;

    @ApiModelProperty("姓名")
    private String name;

    @ApiModelProperty("手机号")
    private String phone;

    @ApiModelProperty("会员等级编码")
    private String memberLevelCode;

    @ApiModelProperty("会员等级名称")
    private String memberLevelName;

    @ApiModelProperty("奖品等级编码")
    private String prizeLevel;

    @ApiModelProperty("奖品等级名称")
    private String prizeLevelName;

    @ApiModelProperty("奖品编码")
    private String prizeCode;

    @ApiModelProperty("奖品名称")
    private String prizeName;

    @ApiModelProperty("单价")
    private BigDecimal unitPrice;

    @ApiModelProperty("总价")
    private BigDecimal totalPrice;

    @ApiModelProperty("奖品类型编码")
    private String prizeType;


    @ApiModelProperty("奖品类型名称")
    private String prizeTypeName;

    @ApiModelProperty("数量")
    private BigDecimal quantity;

    @ApiModelProperty("领取状态code,数据字典:mms_claim_status 枚举:ClaimStatusEnum")
    private String claimStatus;

    @ApiModelProperty("领取时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date claimTime;

    @ApiModelProperty("使用状态,数据字典:mms_employ_status 枚举:EmployStatusEnum")
    private String employStatus;

    @ApiModelProperty("使用时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date employTime;

    @ApiModelProperty("地址")
    private String address;

    @ApiModelProperty("领奖小提示")
    private String hint;

    @ApiModelProperty("大转盘活动结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endDate;

}
