package com.biz.crm.member.business.member.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.biz.crm.member.business.member.sdk.dto.RaffleMemberDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import java.util.List;

/**
 * 大转盘活动奖品信息Vo
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/19 13:37
 **/
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "RafflePrizeVo", description = "大转盘活动奖品信息Vo")
public class RafflePrizeVo extends TenantFlagOpVo {


    @ApiModelProperty("大转盘活动编码")
    private String raffleCode;

    @ApiModelProperty("编码")
    private String code;

    @ApiModelProperty("编码")
    private String rafflePrizeCode;

    @ApiModelProperty("会员等级编码")
    private String memberLevelCode;

    @ApiModelProperty("会员等级名称")
    private String memberLevelName;

    @ApiModelProperty("奖品发完选择")
    private String prizeOverSelect;

    @ApiModelProperty("抽奖奖品池")
    private String prizePool;

    @ApiModelProperty("明细")
    private List<RafflePrizeDetailsVo> details;

    @ApiModelProperty("会员等级集合")
    List<RaffleMemberDto> memberLevels;

    @ApiModelProperty("会员等级json")
    private String memberLevelJson;

    //----大转盘次数配置信息
    @ApiModelProperty("一段每天抽奖次数")
    private Integer oneRaffleNum;

    @ApiModelProperty("一段每次消耗积分")
    private Integer oneRaffleUseIntegral;

    @ApiModelProperty("二段每天抽奖次数")
    private Integer twoRaffleNum;

    @ApiModelProperty("二段每次消耗积分")
    private Integer twoRaffleUseIntegral;
}
