package com.biz.crm.member.business.member.sdk.vo;

import com.biz.crm.business.common.sdk.vo.WorkflowFlagOpVo;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.Column;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 实物订单vo
 *
 * @author zouhs
 * @date 2023-06-14 14:52:44
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "实物订单Vo")
public class RealOrderVo extends WorkflowFlagOpVo {

  @ApiModelProperty("订单号")
  private String orderCode;

  @ApiModelProperty("订单状态,数据字典:mms_real_order_status,枚举:RealOrderStatusEnum")
  private String orderStatus;

  @ApiModelProperty("订单类型,数据字典:mms_real_order_type,枚举:RealOrderTypeEnum")
  private String orderType;

  @ApiModelProperty("订单来源,数据字典:mms_order_source,枚举:OrderSourceEnum")
  private String orderSource;

  @ApiModelProperty("兑换合计支付积分")
  private Integer integralNum;

  @ApiModelProperty("商品缩略图")
  private String productImg;

  @ApiModelProperty("商品价格(单价)")
  private BigDecimal integralPrice;

  @ApiModelProperty("关联客户编码")
  private String userCode;

  @ApiModelProperty("关联客户名称")
  private String userName;

  @ApiModelProperty("下单时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date orderTime;

  @ApiModelProperty("下单人姓名")
  private String orderName;

  @ApiModelProperty("下单人手机号")
  private String orderPhone;

  @ApiModelProperty("商品名称")
  private String productName;

  @ApiModelProperty("商品编码")
  private String productCode;

  @ApiModelProperty("商品数量")
  private Integer productNum;

  @ApiModelProperty("关联组织编码")
  private String orgCode;

  @ApiModelProperty("关联组织名称")
  private String orgName;

  @ApiModelProperty("核销人编码")
  private String writeOffCode;

  @ApiModelProperty("核销人")
  private String writeOffName;

  @ApiModelProperty("核销时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date writeOffTime;

  @ApiModelProperty("关联经销商编码")
  private String relationAgentCode;

  @ApiModelProperty("关联经销商")
  private String relationAgentName;

  @ApiModelProperty("快递单号")
  private String expressNum;

  @ApiModelProperty("是否分发 Y-N")
  private String flagDistribute;

  @ApiModelProperty("办事处负责人编码")
  private String officeCode;

  @ApiModelProperty("办事处负责人")
  private String officeName;

  @ApiModelProperty("办事处负责人手机号")
  private String officePhone;

  @ApiModelProperty("业务员编码")
  private String salesmanCode;

  @ApiModelProperty("业务员")
  private String salesmanName;

  @ApiModelProperty("业务员手机号")
  private String salesmanPhone;

  @ApiModelProperty("签收时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date receiptTime;

  @ApiModelProperty("收货人")
  private String receiptName;

  @ApiModelProperty("收货人手机号")
  private String receiptPhone;

  @ApiModelProperty("收货地址")
  private String receiptAddress;

  @ApiModelProperty("结算状态,数据字典:mms_order_settle_status,枚举:OrderSettleStatusEnum")
  private String settleStatus;

  /**
   * 工作流参数
   */
  @ApiModelProperty("工作流参数")
  private ProcessBusinessDto processBusiness;

  //
  @ApiModelProperty("关联中奖记录编码")
  private String relationCode;

}

