package com.biz.crm.member.business.member.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 景点管理Vo
 *
 * @author hupan
 * @date 2023/6/20 11:07
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "景区管理Vo")
public class ScenicAreaManagementVo extends TenantFlagOpVo {

  @ApiModelProperty("VR景区编码")
  @Column(name = "code", length = 64, columnDefinition = "VARCHAR(64) COMMENT 'VR景区编码'")
  private String code;

  @ApiModelProperty("VR景区名称")
  @Column(name = "name", length = 64, columnDefinition = "VARCHAR(64) COMMENT 'VR景区名称'")
  private String name;

  @ApiModelProperty("浏览量")
  @Column(name = "view_number", length = 5, columnDefinition = "int(5) COMMENT '浏览量'")
  private Integer viewNumber;

  @ApiModelProperty("16进制背景颜色")
  @Column(name = "scenic_icon_background", length = 64, columnDefinition = "VARCHAR(64) COMMENT '16进制背景颜色'")
  private String scenicIconBackground;

  @ApiModelProperty("景区背景图")
  private String backgroundPicture;

  @ApiModelProperty("景区icon")
  private String scenicIcon;

  @ApiModelProperty("锚点icon")
  private String anchorIcon;
}
