package com.biz.crm.member.business.member.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 签到规则明细vo
 *
 * @author zouhs
 * @date 2023-06-15 16:46:55
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "签到规则明细Vo")
public class SignInRuleDetailVo extends TenantFlagOpVo {

  @ApiModelProperty("签到规则ID")
  private String signInId;

  @ApiModelProperty("本月连续签到X天")
  private Integer linkDayNum;

  @ApiModelProperty("可额外获得x积分")
  private Integer linkIntegralNum;

  @ApiModelProperty("图标")
  private String iconImage;

  @ApiModelProperty("描述")
  private String signDesc;

  @ApiModelProperty("排序")
  private Integer seq;

  @ApiModelProperty("已领取")
  private Boolean arrived = Boolean.FALSE;
}

