package com.biz.crm.member.business.member.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.List;
import lombok.Data;

/**
 * @author 吴平
 * @version 1.0.0
 * @data 2023/6/29 11:51
 * @description 小程序簽到信息Vo
 */
@ApiModel(value = "SignInfoVo", description = "小程序签到信息Vo")
@Data
public class SignInfoVo extends TenantFlagOpVo {
  @ApiModelProperty("连续签到天数")
  private Integer continueSignDay;

  @ApiModelProperty("再连续签到天数")
  private Integer nextRemainSignDay;

  @ApiModelProperty("下一次连续签到可获得多少积分")
  private BigDecimal lastObtain;

  @ApiModelProperty("今天是否已签到")
  private Boolean todaySign;

  @ApiModelProperty("签到规则")
  private SignInRuleVo signInRuleVo;

  @ApiModelProperty("连续签到详情")
  private List<SignInRuleDetailVo> signInRuleDetailVos;

  @ApiModelProperty("最多额外可获得积分")
  private BigDecimal maxExtendObtain;
}
