package com.biz.crm.member.business.member.sdk.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 奖品统计vo
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/29 09:55
 **/
@Data
@ApiModel(value = "StaticsPrizeVo",description = "奖品统计vo")
public class StaticsPrizeVo {

    @ApiModelProperty("总数量")
    private BigDecimal totalNum = BigDecimal.ZERO;

    @ApiModelProperty("可投放数量/奖品库存")
    private BigDecimal canPutNum;

    @ApiModelProperty("投放数量")
    private BigDecimal putInventoryNum = BigDecimal.ZERO;

    @ApiModelProperty("投放已中奖")
    private BigDecimal putNumHit = BigDecimal.ZERO;

    @ApiModelProperty("中奖已领取")
    private BigDecimal claimed = BigDecimal.ZERO;

    @ApiModelProperty("中奖未领取")
    private BigDecimal waitClaimed = BigDecimal.ZERO;

    @ApiModelProperty("中奖已过期")
    private BigDecimal expired = BigDecimal.ZERO;

    @ApiModelProperty("领取已使用")
    private BigDecimal useClaimed = BigDecimal.ZERO;

    @ApiModelProperty("领取未使用")
    private BigDecimal unUseClaimed = BigDecimal.ZERO;

    @ApiModelProperty("领取已过期")
    private BigDecimal expiredClaimed = BigDecimal.ZERO;
}
