package com.biz.crm.member.business.member.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author hupan
 * @date 2023/6/21 10:56
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "系统设置明细Vo")
public class SystemSettingsDetailVo extends TenantFlagOpVo {

  @ApiModelProperty("类型，枚举，枚举数据字典mms_system_settings_type，枚举类SystemSettingsTypeEnum")
  private String type;

  @ApiModelProperty("属性名称,枚举，枚举数据字典mms_system_settings_detail，枚举类SystemSettingsDetailEnum")
  private String typeKey;

  @ApiModelProperty("属性值，存储短数据")
  private String typeValue;

  @ApiModelProperty("属性值，存储长文本，比如公司介绍")
  private String typeValueText;
}
