package com.biz.crm.member.business.member.sdk.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import javax.persistence.Column;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * @author hupan
 * @date 2023/6/29 13:58
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "品鉴顾问邀请记录Vo")
public class TaskingAdvisorInviteRecordVo extends TenantFlagOpVo {

  @ApiModelProperty("会员编码")
  private String memberCode;

  @ApiModelProperty("会员名称")
  private String memberName;

  @ApiModelProperty("会员手机号")
  private String memberPhone;

  @ApiModelProperty("会员成长值")
  private Integer currentGrow;

  @ApiModelProperty("会员累计成长值")
  private Integer accumulateGrow;

  @ApiModelProperty("注册时间")
  @TableField(value = "member_register")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date memberRegister;

  @ApiModelProperty("品鉴顾问编码")
  private String tastingCode;

  @ApiModelProperty("品鉴顾问名称")
  private String tastingName;

  @ApiModelProperty("品鉴顾问手机号")
  private String tastingPhone;

  @ApiModelProperty("关联组织编码")
  private String linkOrgCode;

  @ApiModelProperty("关联组织")
  private String linkOrgName;
}
