package com.biz.crm.member.business.member.sdk.vo;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 品鉴顾问分页查询结果vo
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/13 11:14
 **/
@Data
@ApiModel(value = "TastingConsultantPageVo",description ="品鉴顾问分页查询结果vo" )
public class TastingConsultantPageVo extends TenantFlagOpVo {

    @ApiModelProperty("品鉴顾问编码")
    private String code;

    @ApiModelProperty("姓名")
    private String name;

    @ApiModelProperty("手机号")
    private String phone;

    @ApiModelProperty("性别")
    private String gender;

    @ApiModelProperty("生日")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date birthday;

    @ApiModelProperty("年龄")
    private Integer age;

    @ApiModelProperty("单位")
    private String company;

    @ApiModelProperty("职位")
    private String position;

    @ApiModelProperty("生效期")
    private String validateTime;

    @ApiModelProperty("有效期（开始）")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date validateStartDate;

    @ApiModelProperty("有效期（开始）")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date validateEndDate;

    @ApiModelProperty("单位编码")
    private String orgCode;

    @ApiModelProperty("单位名称")
    private String orgName;

    @ApiModelProperty("单位类型,数据字典:mms_org_type,枚举:OrgTypeEnum")
    private String orgType;

    @ApiModelProperty("生效状态,数据字典:mms_tasting_consultant_status,枚举:TastingConsultantStatusEnum")
    private String status;

    @ApiModelProperty("生效状态,数据字典:mms_validate_status,枚举:ValidateStatusEnum")
    private String statusFlag;

    @ApiModelProperty("累计邀请会员数量")
    private BigDecimal totalMemberNum;

    @ApiModelProperty("累计邀请会员获取成长值")
    private BigDecimal totalGrowthValue;




}
