package com.biz.crm.member.business.member.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * 品鉴顾问Vo
 *
 * @Description
 * @Author monroe
 * @Date 2023/6/13 11:04
 **/
@ApiModel(value = "TastingConsultantVo",description = "品鉴顾问Vo")
@Data
public class TastingConsultantVo extends TenantFlagOpVo {

    @ApiModelProperty("品鉴顾问编码")
    private String code;

    @ApiModelProperty("姓名")
    private String name;

    @ApiModelProperty("手机号")
    private String phone;

    @ApiModelProperty("性别")
    private String gender;

    @ApiModelProperty("生日")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date birthday;

    @ApiModelProperty("年龄")
    private Integer age;

    @ApiModelProperty("单位")
    private String company;

    @ApiModelProperty("职位")
    private String position;

    @ApiModelProperty("有效期（开始）")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date validateStartDate;

    @ApiModelProperty("有效期（开始）")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date validateEndDate;


    @ApiModelProperty("关联权益")
    private List<TastingRelBenefitsVo> benefits;

    @ApiModelProperty("关联客户")
    private List<TastingRelCustomerVo> customers;
}
