package com.biz.crm.member.business.member.sdk.vo.applet;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 当前日期会员获取积分信息
 *
 * @Description
 * @Author monroe
 * @Date 2023/7/5 16:08
 **/
@Data
@ApiModel("节日积分信息")
public class AppletHolidayIntegralVo {

    @ApiModelProperty("会员编码")
    private String memberCode;

    @ApiModelProperty("会员编码")
    private String holidayCode;

    @ApiModelProperty("节日积分倍数")
    private BigDecimal multiple;

    @ApiModelProperty("单个用户额外积分上限")
    private Integer extraIntegralTop;

    @ApiModelProperty("渠道")
    private String channel;

    @ApiModelProperty("节日类型")
    private String type;

    @ApiModelProperty("节日日期开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date holidayStartDate;

    @ApiModelProperty("节日日期结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date holidayEndDate;

}
