package com.biz.crm.member.business.member.sdk.vo.applet;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * 小程序会员我的信息
 * @author zouhs
 * @date 2023/6/29
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "AppletMemberHoneVo", description = "小程序会员我的信息")
public class AppletMemberHoneVo implements Serializable {

  @ApiModelProperty("会员编码")
  private String memberCode;

  @ApiModelProperty("会员昵称")
  private String memberNick;

  @ApiModelProperty("会员姓名")
  private String memberName;

  @ApiModelProperty("会员头像")
  private String memberAvatar;

  @ApiModelProperty("会员生日")
  private String memberBirthday;

  @ApiModelProperty("当前积分")
  private Integer currentIntegral;

  @ApiModelProperty("当前成长值")
  private Integer currentGrow;

  @ApiModelProperty("待兑权益数")
  private Integer stayBenefitsNum;

  @ApiModelProperty("大转盘奖品")
  private Integer bigWheelPrizes;

  @ApiModelProperty("等级编码")
  private String levelCode;

  @ApiModelProperty("等级名称")
  private String levelName;

  @ApiModelProperty("下一级别等级名称")
  private String nextLevelName;

  @ApiModelProperty("成长值区间开始")
  private Integer growStart;

  @ApiModelProperty("成长值区间结束")
  private Integer growEnd;

  @ApiModelProperty("第一年该等级卡片")
  private String cardImageOne;

  @ApiModelProperty("连续一年以上等级卡片")
  private String cardImageTwo;

  @ApiModelProperty("品鉴顾问编码")
  private String tastingCode;

  @ApiModelProperty("品鉴顾问")
  private String tastingName;

  @ApiModelProperty("品鉴顾问手机号")
  private String tastingPhone;

  @ApiModelProperty("品鉴顾问卡片")
  private String linkTastingCard;

  @ApiModelProperty("会籍到期日期")
  private String memberLevelExpires;

  @ApiModelProperty("升级规则")
  private String levelRule;

}
