package com.biz.crm.member.business.member.sdk.vo.applet;

import com.biz.crm.member.business.member.sdk.vo.DummyOrderUserVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 权益兑换
 * @author zouhs
 * @date 2023/7/3
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "权益兑换")
public class AppletMemberInfoBenefits implements Serializable {

  @ApiModelProperty("ID")
  private String id;

  @ApiModelProperty("订单ID")
  private String orderId;

  @ApiModelProperty("会员编码")
  private String memberCode;

  @ApiModelProperty("权益编码")
  private String benefitsCode;

  @ApiModelProperty("权益名称")
  private String benefitsName;

  @ApiModelProperty("权益类型,数据字典:mms_benefits_type,枚举:BenefitsTypeEnum")
  private String benefitsType;

  @ApiModelProperty("兑换状态,数据字典:mms_member_info_benefits_exchange_status,枚举:MemberInfoBenefitsStatusEnum")
  private String exchangeStatus;

  @ApiModelProperty("会员权益类型,数据字典:mms_member_info_benefits_member_benefits_type,枚举:MemberInfoMemberBenefitsTypeEnum")
  private String memberBenefitsType;

  @ApiModelProperty("转赠人编码")
  private String giftCode;

  @ApiModelProperty("转赠人姓名")
  private String giftName;

  @ApiModelProperty("转赠人手机号")
  private String giftPhone;

  @ApiModelProperty("兑换时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date exchangeTime;

  @ApiModelProperty("关联订单号")
  private String orderCode;

  @ApiModelProperty("单位,数据字典:mms_benefits_unit,枚举:BenefitsUnitEnum")
  private String unit;

  @ApiModelProperty("产品图片")
  private String productImage;

  @ApiModelProperty("产品详情")
  private String productDesc;

  @ApiModelProperty("兑换有效期(月)")
  private Integer exchangeValidPeriod;

  @ApiModelProperty("使用有效期(天)")
  private Integer useValidPeriod;

  @ApiModelProperty("数量")
  private Integer num;

  @ApiModelProperty("等级关联权益")
  private String levelManageBenefitsCode;

  @ApiModelProperty("关联组织编码")
  private String orgCode;

  @ApiModelProperty("关联组织名称")
  private String orgName;

  @ApiModelProperty("获得权益时间")
  @JsonFormat(
      locale = "zh",
      timezone = "GMT+8",
      pattern = "yyyy-MM-dd HH:mm:ss"
  )
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date obtainBenefitsTime;

  @ApiModelProperty("权益过期时间")
  @JsonFormat(
      locale = "zh",
      timezone = "GMT+8",
      pattern = "yyyy-MM-dd HH:mm:ss"
  )
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date endBenefitsTime;

  @ApiModelProperty("订单状态,数据字典:mms_real_order_status,枚举:RealOrderStatusEnum")
  private String realOrderStatus;

  @ApiModelProperty("订单状态,数据字典:mms_dummy_order_status,枚举:DummyOrderStatusEnum")
  private String dummyOrderStatus;

  @ApiModelProperty("收货人")
  private String receiptName;

  @ApiModelProperty("收货人手机号")
  private String receiptPhone;

  @ApiModelProperty("收货地址")
  private String receiptAddress;

  @ApiModelProperty("快递单号")
  private String expressNum;

  @ApiModelProperty("报名信息")
  private List<DummyOrderUserVo> list;

}
