package com.biz.crm.member.business.member.sdk.vo.applet;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 小程序会员基础信息
 * @author zouhs
 * @date 2023/6/29
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "AppletMemberInfoVo", description = "小程序会员基础信息")
public class AppletMemberInfoVo implements Serializable {

  @ApiModelProperty("会员编码")
  private String memberCode;

  @ApiModelProperty("会员昵称")
  private String memberNick;

  @ApiModelProperty("会员手机号")
  private String memberPhone;

  @ApiModelProperty("会员姓名")
  private String memberName;

  @ApiModelProperty("会员头像")
  private String memberAvatar;

  @ApiModelProperty("会员生日")
  private String memberBirthday;

  @ApiModelProperty("注册时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date memberRegister;

  @ApiModelProperty("邀请人数")
  private Integer inviteNum;

  @ApiModelProperty("邀请人编码")
  private String inviteMemberCode;

  @ApiModelProperty("邀请人")
  private String inviteMemberName;

  @ApiModelProperty("激活状态,数据字典:mms_member_info_active_status,枚举:MemberActiveStatusEnum")
  private String activeStatus;

  @ApiModelProperty("审批状态,数据字典:mms_member_info_approval_status,枚举:MemberApprovalStatusEnum")
  private String approvalStatus;

  @ApiModelProperty("关联品鉴顾问编码")
  private String linkTastingCode;

  @ApiModelProperty("关联品鉴顾问")
  private String linkTastingName;

  @ApiModelProperty("关联品鉴顾问手机号")
  private String linkTastingPhone;

  @ApiModelProperty("等级编码")
  private String levelCode;

  @ApiModelProperty("等级名称")
  private String levelName;

  @ApiModelProperty("是否刚注册")
  private Boolean firstLogin = false;

}
