package com.biz.crm.member.business.member.sdk.vo.applet;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * @author hupan
 * @date 2023/7/4 11:26
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "AppletPopupNotifyVo", description = "小程序弹窗Vo")
public class AppletPopupNotifyVo implements Serializable {

  @ApiModelProperty("会员编码")
  private String memberCode;

  @ApiModelProperty("触发类型,枚举: 数据字典:mms_trigger_type,枚举:TriggerTypeEnum")
  private String triggerType;

  @ApiModelProperty("触发条件,枚举: 数据字典:mms_trigger_condition,枚举:TriggerConditionEnum")
  private String triggerConditions;

  @ApiModelProperty("弹窗开始时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date startTime;

  @ApiModelProperty("弹窗结束时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date endTime;
}
