package com.biz.crm.member.business.member.sdk.vo.login;

import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import lombok.Data;

@Data
public class MemberUserDetails extends AbstractCrmUserIdentity {

    @ApiModelProperty("会员编码")
    private String memberCode;

    @ApiModelProperty("会员昵称")
    private String memberNick;

    @ApiModelProperty("会员手机号")
    private String memberPhone;

    @ApiModelProperty("会员姓名")
    private String memberName;

    @ApiModelProperty("会员生日")
    private String memberBirthday;

    @ApiModelProperty("用户类型 1 会员 2 游客")
    private String userType;

    @ApiModelProperty("岗位编码")
    private String postCode;

    @ApiModelProperty("岗位名称")
    private String postName;

    @ApiModelProperty("是否刚注册")
    private Boolean firstLogin = false;

    @ApiModelProperty("菜单编码")
    private List<String> menuCodeList;

    @Override
    public String getPostCode() {
        return this.postCode;
    }

    @Override
    public String getPostName() {
        return this.postName;
    }
}
