/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.member.business.member.sdk.utils;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.swing.filechooser.FileSystemView;

public class QRBarCodeUtil {
    private static final int CODE_WIDTH = 400;
    private static final int CODE_HEIGHT = 400;
    private static final int FRONT_COLOR = 0;
    private static final int BACKGROUND_COLOR = 0xFFFFFF;

    public static void main(String[] args) {
        String codeContent1 = "https://www.baidu.com/";
        QRBarCodeUtil.createCodeToFile(codeContent1, null, null);
        String codeContent2 = "4c86fed8-7ac9-4db7-956e-6cfe84268059";
        QRBarCodeUtil.createCodeToFile(codeContent2, null, null);
    }

    public static void createCodeToFile(String codeContent, File codeImgFileSaveDir, String fileName) {
        try {
            if (codeContent == null || "".equals(codeContent)) {
                System.out.println("\u4e8c\u7ef4\u7801\u5185\u5bb9\u4e3a\u7a7a\uff0c\u4e0d\u8fdb\u884c\u64cd\u4f5c...");
                return;
            }
            codeContent = codeContent.trim();
            if (codeImgFileSaveDir == null || codeImgFileSaveDir.isFile()) {
                codeImgFileSaveDir = FileSystemView.getFileSystemView().getHomeDirectory();
                System.out.println("\u4e8c\u7ef4\u7801\u56fe\u7247\u5b58\u5728\u76ee\u5f55\u4e3a\u7a7a\uff0c\u9ed8\u8ba4\u653e\u5728\u684c\u9762...");
            }
            if (!codeImgFileSaveDir.exists()) {
                codeImgFileSaveDir.mkdirs();
                System.out.println("\u4e8c\u7ef4\u7801\u56fe\u7247\u5b58\u5728\u76ee\u5f55\u4e0d\u5b58\u5728\uff0c\u5f00\u59cb\u521b\u5efa...");
            }
            if (fileName == null || "".equals(fileName)) {
                fileName = new Date().getTime() + ".png";
                System.out.println("\u4e8c\u7ef4\u7801\u56fe\u7247\u6587\u4ef6\u540d\u4e3a\u7a7a\uff0c\u968f\u673a\u751f\u6210 png \u683c\u5f0f\u56fe\u7247...");
            }
            HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>();
            hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
            hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.M);
            hints.put(EncodeHintType.MARGIN, 1);
            MultiFormatWriter multiFormatWriter = new MultiFormatWriter();
            BitMatrix bitMatrix = multiFormatWriter.encode(codeContent, BarcodeFormat.QR_CODE, 400, 400, hints);
            BufferedImage bufferedImage = new BufferedImage(400, 400, 4);
            for (int x = 0; x < 400; ++x) {
                for (int y = 0; y < 400; ++y) {
                    bufferedImage.setRGB(x, y, bitMatrix.get(x, y) ? 0 : 0xFFFFFF);
                }
            }
            File codeImgFile = new File(codeImgFileSaveDir, fileName);
            ImageIO.write((RenderedImage)bufferedImage, "png", codeImgFile);
            System.out.println("\u4e8c\u7ef4\u7801\u56fe\u7247\u751f\u6210\u6210\u529f\uff1a" + codeImgFile.getPath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

