package com.biz.crm.sfa.admin.web.exports.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.sfa.admin.web.exports.dto.AttendanceRecordDetailExportDto;
import com.biz.crm.sfa.admin.web.exports.vo.AttendanceRecordDetailExportVo;
import com.biz.crm.sfa.admin.web.report.service.AttendanceRecordDetailVoService;
import com.biz.crm.sfa.admin.web.report.vo.AttendanceRecordDetailVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @description: 考勤明细报表
 * @author: rentao
 * @date: 2022/7/8 15:52
 */
@Component
public class AttendanceRecordDetailExportProcess implements ExportProcess<AttendanceRecordDetailExportVo> {

  @Autowired
  private AttendanceRecordDetailVoService attendanceRecordDetailVoService;

  @Override
  public Integer getTotal(Map<String, Object> params) {
    AttendanceRecordDetailExportDto dto = this.convertParams(params);
    Pageable pageable = PageRequest.of(0, 50);
    long total = this.attendanceRecordDetailVoService.findDetailByConditions(pageable, dto).getTotal();
    return Math.toIntExact(total);
  }

  @Override
  public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
    AttendanceRecordDetailExportDto dto = this.convertParams(params);
    Pageable pageable = PageRequest.of(vo.getPageNo(), vo.getPageSize());
    Page<AttendanceRecordDetailVo> page = this.attendanceRecordDetailVoService.findDetailByConditions(pageable, dto);
    //调整数据
    List<AttendanceRecordDetailVo> records = page.getRecords();
    List<AttendanceRecordDetailExportVo> data = this.adjustData(records);
    return JSON.parseArray(JSON.toJSONString(data));
  }

  @Override
  public Class<AttendanceRecordDetailExportVo> findCrmExcelVoClass() {
    return AttendanceRecordDetailExportVo.class;
  }

  @Override
  public String getBusinessCode() {
    return "SFA_ATTENDANCE_RECORD_DETAIL_EXPORT";
  }

  @Override
  public String getBusinessName() {
    return "考勤明细报表导出";
  }

  /**
   * 获取参数
   *
   * @param params
   * @return
   */
  private AttendanceRecordDetailExportDto convertParams(Map<String, Object> params) {
    // map 参数转换为对应的dto参数对象，可以手工进行修改设置
    AttendanceRecordDetailExportDto dto = JSON.parseObject(JSON.toJSONString(params), AttendanceRecordDetailExportDto.class);
    dto.setTenantCode(TenantUtils.getTenantCode());
    return dto;
  }

  /**
   * 调整数据
   *
   * @param data
   */
  private List<AttendanceRecordDetailExportVo> adjustData(List<AttendanceRecordDetailVo> data) {
    if (CollectionUtils.isEmpty(data)) {
      return new ArrayList<>(0);
    }
    List<AttendanceRecordDetailExportVo> exportVos = new ArrayList<>();
    for (AttendanceRecordDetailVo datum : data) {
      AttendanceRecordDetailExportVo exportVo = new AttendanceRecordDetailExportVo();
      BeanUtils.copyProperties(datum, exportVo);
      exportVos.add(exportVo);
    }
    return exportVos;
  }
}
